# Tamela Health Website

A responsive website for Tamela Health, showcasing their AI-assisted diagnostic tool aimed at reducing infant and maternal mortality rates.

## Website Structure

The website includes the following sections:

1. **Home/Hero Section**: Introduction to Tamela Health's mission
2. **Problem Section**: Overview of maternal and infant mortality challenges
3. **Solution Section**: Details about Tamela's AI-powered diagnostic tool
4. **Impact Section**: One-year and five-year goals for the company
5. **Team Section**: Information about team members and advisors
6. **Contact Section**: Contact form and company information
7. **Footer**: Navigation links and copyright information

## Files Included

- `index.html` - Main HTML file
- `css/styles.css` - CSS styles for the website
- `js/script.js` - JavaScript functionality
- `images/` - Directory for image assets (placeholder images)

## Technical Information

- **Color Scheme**: Primary #292E75 (dark blue) and Secondary #D86735 (orange)
- **Font**: Poppins (loaded from Google Fonts)
- **Icons**: Font Awesome 6.4.0 (loaded from CDN)
- **Responsiveness**: Fully responsive design with mobile-first approach

## Setup Instructions

1. Upload all files to your web server, maintaining the directory structure
2. Ensure the following directory structure:
   ```
   /
   ├── index.html
   ├── css/
   │   └── styles.css
   ├── js/
   │   └── script.js
   └── images/
       ├── tamela-logo.png
       ├── tamela-logo-white.png
       ├── hero-image.png
       ├── solution-image.png
       └── [team member images]
   ```

## Image Requirements

You'll need to create or source the following images:

1. `tamela-logo.png` - Company logo for header (dark version)
2. `tamela-logo-white.png` - Company logo for footer (white version)
3. `hero-image.png` - Main image showing the product or service in action
4. `solution-image.png` - Image illustrating the solution/product interface
5. Team member images (named accordingly):
   - `adewunmi-adeagbo.png`
   - `dr-ayomide-esan.png`
   - `dr-oyebanke-abejirin.png`
   - `samson-owoka.png`
   - `olugbenga-abejirin.png`

## Customization

- Edit the HTML content to update any text information
- Modify the CSS to adjust styles, colors, or layout
- Extend the JavaScript for additional functionality

## Contact Form

The contact form currently has client-side validation but doesn't process submissions. To make the form functional:

1. Set up a server-side script to handle form submissions
2. Update the form action attribute and JavaScript as needed

## Browser Compatibility

The website is designed to work on modern browsers including:
- Chrome
- Firefox
- Safari
- Edge

## Credits

- Fonts: Google Fonts (Poppins)
- Icons: Font Awesome
